//
//  UIView+OLExtend.h
//  OKLineDemo
//
//  Created by hxk on 17/3/31.
//  Copyright © 2017年 HZOL. All rights reserved.
//

#import <UIKit/UIKit.h>
@interface UIView (OLExtend)
#pragma mark - Frame
@property (nonatomic, assign) CGFloat ol_x;
@property (nonatomic, assign) CGFloat ol_y;
@property (nonatomic, assign) CGFloat ol_right;
@property (nonatomic,assign) CGFloat ol_top;
@property (nonatomic, assign) CGFloat ol_bottom;
@property (nonatomic, assign) CGFloat ol_centerX;
@property (nonatomic, assign) CGFloat ol_centerY;
@property (nonatomic, assign) CGFloat ol_width;
@property (nonatomic, assign) CGFloat ol_height;
@property (nonatomic, assign) CGSize  ol_size;
@property (nonatomic,assign) CGPoint  ol_origin;


#pragma mark - NIB
/**
 *  自动从xib创建视图
 */
+(instancetype)viewFromXIB;
    
// 判断View是否显示在屏幕上
- (BOOL)isDisplayedInScreen;


/**
 加载NIB
 */
+ (UINib *)ol_loadNib;
+ (UINib *)ol_loadNibNamed:(NSString*)nibName;
+ (UINib *)ol_loadNibNamed:(NSString*)nibName bundle:(NSBundle *)bundle;


/**
 加载NIb并获取NIb对应的UIView的实例
 */
+ (instancetype)ol_loadInstanceFromNib;
+ (instancetype)ol_loadInstanceFromNibWithName:(NSString *)nibName;
+ (instancetype)ol_loadInstanceFromNibWithName:(NSString *)nibName owner:(id)owner;
+ (instancetype)ol_loadInstanceFromNibWithName:(NSString *)nibName owner:(id)owner bundle:(NSBundle *)bundle;



#pragma mark - Shadow
/**
 设置阴影

 @param color         阴影颜色
 @param setSize       阴影偏移量
 @param shadowRadius  阴影的圆角
 @param shadowOpacity 阴影透明度
 */
- (void)viewSetShadowWithColor:(UIColor *)color shadowOffset:(CGSize)setSize shadowRadius:(CGFloat)shadowRadius shadowOpacity:(CGFloat)shadowOpacity;


/**
 设置边框和圆角
 @param borderWidth  borderWidth
 @param boaderColor  boaderColor
 @param cornerRadius cornerRadius
 */
-(void)ol_setBorderWidth:(CGFloat)borderWidth borderColor:(UIColor *)boaderColor cornerRadius:(CGFloat)cornerRadius;


/**
 view的底部
 为某一View的Bottom边添加Border
 @param color       color
 @param borderWidth borderWidth
 */
- (void)ol_addBottomBorderWithColor:(UIColor *)color width:(CGFloat) borderWidth;

/**
 *  顶部添加边框
 */
- (void)ol_addTopBorderWithColor:(UIColor *)color width:(CGFloat) borderWidth;

#pragma mark - OtherHelp
/**
 返回当前View所在的ViewController,此值可能是nil
 @return ViewController
 */
-(UIViewController *)viewController;


/**
 *  @brief  找到指定类名的SuperView对象
 *  @param clazz SuperView类名
 *  @return view对象
 */
- (id)ol_findSuperViewWithSuperViewClass:(Class)clazz;

/**
 *  截屏
 */
- (nullable UIImage *)snapshotImage;
@end
